/** @file   <???>.cpp
 * @brief   Implementation of ScoresAnimation.cpp class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/04/03 20:59:15 $
 * @author  Tomi Lamminsaari
 */

#include "ScoresAnimation.h"


namespace WeWantWar {

const int KAnim120Pts = 0;
const int KAnim200Pts = 1;
const int KAnim220Pts = 2;
const int KAnim350Pts = 3;
const int KAnim450Pts = 4;
const int KAnim500Pts = 5;
const int KAnim800Pts = 6;
const int KAnim1000Pts = 7;
const int KAnim1200Pts = 8;

///
/// Constants, datatypes and static methods
/// ============================================================================

int ScoresAnimation::getKillScoresAnimationUid( ObjectID::Type aObjectType )
{
  int animUid = -1;
  switch ( aObjectType ) {
    case ( ObjectID::TYPE_CARNIVOREALIEN ): {
      animUid = KAnim200Pts;
      break;
    }
    case ( ObjectID::TYPE_SMALLWORMALIEN ): {
      animUid = KAnim120Pts;
      break;
    }
    case ( ObjectID::TYPE_WINGEDALIEN ): {
      animUid = KAnim220Pts;
      break;
    }
    case ( ObjectID::TYPE_PROCTORALIEN ): {
      animUid = KAnim450Pts;
      break;
    }
    case ( ObjectID::TYPE_MINIGUNALIEN ): {
      animUid = KAnim500Pts;
      break;
    }
    case ( ObjectID::TYPE_PREDATORALIEN ): {
      animUid = KAnim350Pts;
      break;
    }
    case ( ObjectID::TYPE_LIGHTBALLALIEN ):
    case ( ObjectID::TYPE_FLAMERALIEN ):
    case ( ObjectID::TYPE_SENTRYGUN ): {
      animUid = KAnim800Pts;
      break;
    }
    case ( ObjectID::TYPE_FIGHTER ): {
      animUid = KAnim1200Pts;
      break;
    }
    default: {
      animUid = -1;
      break;
    }
  }
  return animUid;
}

};  // end of namespace
